; OverlayInfoMux Alpha 0.4
; simplify: MOV		R0, SP, ADD		R0, #sp_refresh_buffer

; developing on Siemens m65v50
; (c) benj9

					AREA benj9, CODE, READONLY  

					IMPORT	mp_Bufferizer
					IMPORT	f092_GetCPUClock
					IMPORT	f093_GetCPULoad
					IMPORT	v02_RamNetCH
					IMPORT	v03_RamNetRX
					IMPORT	f160_Uncicode_sprintf
					IMPORT	f161_Unicode_CopyStr2Str
					IMPORT	f162_Unicode_GetCharByPosition
					IMPORT	f077_CallAfterTimer
					IMPORT	f063_SelectColor
					IMPORT	f081_GetNetMode
					IMPORT	f035_DrawImg
					IMPORT	f036_DrawImage2
					IMPORT	f037_DrawCanvas
					IMPORT	f038_DrawImageBW
					IMPORT	v19_ram_mainscreen_accu_icon
					IMPORT	f020_malloc
					IMPORT	f066_IsScreenSaver
					IMPORT	v18_ram_IsShutdown
					
					EXPORT	e_refresh
					EXPORT	e_screen


; ----- masterpatch midlet meta description ----------------------

mp__record_size			EQU	0xB0
mp__first_record_off	EQU 0x20


; ----- masterpatch midlet absolute ------------------------------

mp_ab_bits_fn_use_ptr	EQU 1
mp_ab_fn1_off			EQU 2
mp_ab_fn2_off			EQU 3
mp_ab_fn3_off			EQU 4
mp_ab_fn4_off			EQU 5
mp_ab_fn5_off			EQU 6
mp_ab_fn1_loadtype		EQU 7
mp_ab_fn2_loadtype		EQU 8
mp_ab_fn3_loadtype		EQU 9
mp_ab_fn4_loadtype		EQU 10
mp_ab_fn5_loadtype		EQU 11
mp_ap_fn1_adr			EQU	12
mp_ap_fn2_adr			EQU	16
mp_ap_fn3_adr			EQU	20
mp_ap_fn4_adr			EQU	24
mp_ap_fn5_adr			EQU	28


; ----- masterpatch midlet relative ------------------------------

; masterpatch midlet relative style record
; first starts at mp__first_record_off, length is mp__record_size
; there are 4 style records: override, mainscreen, screensaver, menues-lists

mp_sy_content			EQU	0
mp_gr_font				EQU	1
mp_gr_alignement		EQU	2
mp_gr_operator			EQU	3

mp_gr_x0				EQU	4
mp_gr_y0				EQU	5
mp_gr_x1				EQU	6
mp_gr_y1				EQU	7

mp_gr_fg_col			EQU	8 ; w
mp_gr_bg_col			EQU	12 ; w

mp_sy_threshold_val		EQU	16 ; w
mp_sy_refresh_time		EQU	20 ; w

mp_tx_func_shift		EQU	24 ; potential 12 functions 
mp_tx_sprintf_format	EQU	36 ; format string length, size 137+1 bytes

mp_sy_threshold_mode	EQU	174 ; 0xAE 
mp_sy_threshold_func	EQU	175 ; 0xAF 


; ----- patch ram usage ------------------------------------------

ram_mode				EQU	0 ; 0=on, 1=off, 2=special style
ram_last_pstyle			EQU 1


; ----- stack usage meta info ------------------------------------

sp_refresh_size			EQU		0x170

; function push/pop shifts

sp_shift_refresh		EQU		8
sp_shift_refr_func		EQU		4
sp_shift_refr_get_focus	EQU		8


; ----- stack usage ----------------------------------------------

sp_refresh_param		EQU		0
sp_refresh_cpuload		EQU		(num_of_funcs - 2) * 4 
sp_refresh_cpuclock		EQU		sp_refresh_cpuload + 4 
sp_refresh_mp_ptr		EQU		sp_refresh_cpuclock + 4 
sp_refresh_timer		EQU		sp_refresh_mp_ptr + 4 
sp_refresh_buffer		EQU		sp_refresh_timer + 4 


; ----- definitions ----------------------------------------------

num_of_funcs		EQU		12

; =====================================================================

					DCB		"OvlayMx04,benj9",0
					
					CODE16
					ENTRY	
					
; =====================================================================

e_external_toggle	LDR		R1, patch_ptr
					LDRB	R0, [R1, #ram_mode]
					ADD		R0, #1
					CMP		R0, #3
					BLT		e_external_toggle_x
					
					MOV		R0, #0
						
e_external_toggle_x	STRB	R0, [R1, #ram_mode]
					BX		LR	
					
; =============================================================	
; start internal func by num in R7

; off=0 cpu_load=1 cpu_clock=2 net_rx=3 net_mode=4 accu_cap=5
; accu_temp=6 time=7 val1=8 val2=9 val3=10 str1=11 str2=12

_function			PUSH	{LR}

					CMP		R7, #num_of_funcs					
					BGE		_func00_off
					
					MOV		R0, #0
					LSL		R7, #1
					SUB		R7, #2
					ADD		PC, R7

					B		_func00_off
					B		_func01_cpu_load
					B		_func02_cpu_clock
					B		_func03_net_rx
					B		_func04_net_mode
					B		_func05_accu_cap
					B		_func06_accu_temp
					B		_func07_time
					B		_func08_val1
					B		_func09_val2
					B		_func10_val3
					B		_func11_string
					B		_func12_string2

; =============================================================	

_func00_off			MOV		R0, #0
					B		_function_x
		
; =============================================================	

_func01_cpu_load	LDR		R0, [SP, #(sp_shift_refresh+sp_shift_refr_func+sp_refresh_cpuload)]
					B		_function_x
					
; ---------------------------------------------------------------------

_func02_cpu_clock	LDR		R0, [SP, #(sp_shift_refresh+sp_shift_refr_func+sp_refresh_cpuclock)]
					B		_function_x
					
; ---------------------------------------------------------------------
					
_func03_net_rx		BL		v03_RamNetRX
					LDRB	R0,[R7]
					B		_function_x
		
; ---------------------------------------------------------------------
					
_func04_net_mode	BL		f081_GetNetMode
					B		_function_x
					
; ---------------------------------------------------------------------
			
_func05_accu_cap	MOV		R0, #0
					B		_function_x
					
; ---------------------------------------------------------------------
				
_func06_accu_temp	MOV		R0, #0
					B		_function_x
					
; ---------------------------------------------------------------------
				
_func07_time		MOV		R0, #0
					B		_function_x
					
; ---------------------------------------------------------------------
					
_func08_val1		LDR		R7, ram_netmode_2
					LDRB	R0,[R7]
					B		_function_x


; ---------------------------------------------------------------------
					
_func09_val2		LDR		R7, ram_funnybyte
					LDRB	R0,[R7]
					B		_function_x
					
; ---------------------------------------------------------------------
					
_func10_val3		LDR		R7, Ram_Timer975_inc
					LDR		R0,[R7]
					B		_function_x
					
; ---------------------------------------------------------------------
					
_func11_string		MOV		R0, #4 ; internal func 4
					;BL		_get_focus
					B		_function_x
					
; ---------------------------------------------------------------------
					
_func12_string2		MOV		R0, #5 ; internal func 5
					;BL		_get_focus
					; B		_function_x
					
; ---------------------------------------------------------------------

_function_x			POP		{PC}
							
; =====================================================================

_get_focus				PUSH	{R6, LR} ; input: R0 = internal function (0-4)
						LDR		R6, [SP, #(sp_shift_refresh+sp_shift_refr_func+sp_shift_refr_get_focus+sp_refresh_mp_ptr)] ; absolute mp buf start
						
						LSL		R1, R0, #2
						ADD		R1, #mp_ap_fn1_adr ; first address in rec
						LDR		R3, [R6, R1] 
						CMP		R3, #0
						BPL		_get_focus_false
						
						LDRB	R1, [R6, #mp_ab_bits_fn_use_ptr]
						MOV		R2, #1
						LSL		R2, R0
						TST		R1, R2
						BEQ		_get_focus_load
						
						LDR		R3, [R3]
						CMP		R3, #0
						BPL		_get_focus_false
						
						MOV		R1, #mp_ab_fn1_off ; first value of rec
						ADD		R1, R0
						LDRB	R1, [R6, R1]	
						ADD		R3, R1
						
_get_focus_load			MOV		R1, #mp_ab_fn1_loadtype ; first value of rec
						ADD		R1, R0
						LDRB	R1, [R6, R1]
						CMP		R1, #1
						BLT		_get_focus_load_b
						BEQ		_get_focus_load_h
						
_get_focus_load_d		LDR		R3, [R3]
						B		_get_focus_load_set
						
_get_focus_load_h		LDRH	R3, [R3]
						B		_get_focus_load_set
						
_get_focus_load_b		LDRB	R3, [R3]

_get_focus_load_set		MOV		R0, R3
						B		_get_focus_x
						
_get_focus_false		MOV		R0, #0

_get_focus_x			POP		{R6, PC}


; ----------------------------------------------------------------------


e_screen			LDR		R0, mp_id
					BL		mp_Bufferizer							
					BEQ		screen_mp_default
											
screen_mp_yes		MOV		R0, #0 ; input : R0=0 from screen. r0=1 from refresher
					BL		_get_style ;output: 1=off, 2=special 3=mainscr, 4=scrsaver, 5=menu/list
					BNE		screen_do
					
					MOV		R5,#0 ; supress string

screen_mp_default	ADR		R6, style_nopatch
									
screen_do			ADD     R0, SP, #0x2C
					
				    LDRB	R2, [R6,#mp_gr_y1] ; [R4,#4]
					STR     R2, [SP]
					
					LDRB    R3, [R6,#mp_gr_x1];  [R4] 
					
					LDRB	R2, [R6,#mp_gr_y0] ; 0
					LDRB	R1, [R6,#mp_gr_x0] ; 0

					LDR		R7, ScreenWindow_Metrics ; R0=buf, R1=x, R2=y, R3=width,[SP]=height
					BLX		R7						

 					LDRB	R2, [R6,#mp_gr_alignement] ; 0 ;  alignement, 0=left 2=center, 4=right
					STR     R2, [SP,#4]
					
					LDRB    R1, [R6,#mp_gr_font]
					STR     R1, [SP]

					MOV     R3, R5 ; wstring
					LDRB	R2, [R6,#mp_gr_operator] ; 0
					ADD     R1, SP, #0x2C
					ADD     R0, SP, #8
					LDR		R7, ScreenWindow_Text ;R0=buffer, R1=points2 general_metrics, R2=inversion?, r3=ptr2ws, SP=font, sp+4=alignement?
					BLX		R7
	
					ADD		R0, SP, #8
					MOV		R1, R6
					ADD		R1, #mp_gr_fg_col
					ADD		R2, R1, #4 ; = R6 + #mp_bg_col]

					LDR		R7, ScreenWindow_Color
					BLX		R7
					
screen_x			LDR		R7, Screen_OverlayDisplay_return
					BX		R7	
										
; =============================================================
			

		
e_refresh			PUSH	{R1-R3, R6} ; delete 1-3
					MOV		R4, R0
					SUB		SP ,#sp_refresh_size ; space
					
					STR		R5, [SP, #sp_refresh_timer]
					LDR		R0, mp_id
					BL		mp_Bufferizer							
					BEQ		refresh_nopatch

					BL		f093_GetCPULoad
					STR		R0, [SP, #sp_refresh_cpuload]
					
					BL		f092_GetCPUClock
					STR		R0, [SP, #sp_refresh_cpuclock]
					
					STR		R5, [SP, #sp_refresh_timer]
					STR		R6, [SP, #sp_refresh_mp_ptr]

					; --- choose config style by state of phone ---------
					
refresh_permit		MOV		R0, #1 ; input : R0=0 from screen. r0=1 from refresher
					BL		_get_style ;output: 1=off, 2=special 3=mainscr, 4=scrsaver, 5=menu/list
					BEQ		refresh_disp_null
					
refresh_permit_cont	LDRB	R0, [R6, #mp_sy_content] ; which type of content
					CMP		R0, #1
					BLT		refresh_disp_null
					BEQ		refresh_nopatch
					
refr_permit_thresho	MOV		R2, R6
					ADD		R2, #mp_sy_threshold_func
					LDRB	R7, [R2] ; is threshold enabled?
					CMP		R7, #0
					BEQ		refr_prep_str
					
					SUB		SP, #sp_shift_refresh ; just to make it compatible
					BL		_function
					ADD		SP, #sp_shift_refresh
					MOV		R2, R6
					ADD		R2, #mp_sy_threshold_val
					LDR		R1, [R2] 
					MOV		R2, R6
					ADD		R2, #mp_sy_threshold_mode
					LDRB	R2, [R2]

					CMP		R2, #1 ; condition direction. 0=eq, 1=le, 2=ge
					BEQ		refr_perm_thre_le
					BGT		refr_perm_thre_ge

refr_perm_thre_eq	CMP		R0, R1 ; focus byte snapped?
					B		refr_perm_thre_x
						
refr_perm_thre_le	CMP		R0, R1 ; focus byte snapped?
					BLE		refr_perm_thre_true
					B		refr_perm_thre_fals
						
refr_perm_thre_ge	CMP		R0, R1 ; focus byte snapped?
					BGE		refr_perm_thre_true

refr_perm_thre_fals	MOV		R1, #1
					B		refr_perm_thre_x

refr_perm_thre_true	MOV		R1, #0				

refr_perm_thre_x	BNE		refresh_disp_null
					
					
					; --- build sprintf argument table ------------------
					
refr_prep_str		SUB		SP, #sp_shift_refresh ; sp=dest ; cheat in r2, r3 in stack transition concept
					
					MOV		R4, R6
					ADD		R4, #mp_tx_func_shift ; r4=src
					MOV		R5, #0 ; counter
					
refr_prep_str_loop	LDRB	R7, [R4, R5]
					BL		_function	
					
					LSL		R1, R5, #2
					MOV		R2, SP
					STR		R0, [R2, R1]
					
					ADD		R5, #1
					CMP		R5, #num_of_funcs
					BLT		refr_prep_str_loop
					
					LDR		R2, [SP]
					LDR		R3, [SP, #4]
					
					ADD		SP, #sp_shift_refresh 
										
					; ----------------------------------
					
refresh_string		MOV		R0, SP
					ADD		R0, #sp_refresh_buffer
					ADD		R1, R0, #4
					STR		R1, [R0]

					MOV		R1, R6
					ADD		R1, #mp_tx_sprintf_format
					BL		f160_Uncicode_sprintf
										
					MOV		R4, SP
					ADD		R4, #sp_refresh_buffer

					B		refresh_disp_out
								
refresh_disp_null	LDR		R1,[R4]
					MOV		R2,#0
					STRH	R2,[R1]
					B		refresh_disp_out
					
refresh_nopatch		MOV		R0, R4
					LDR		R7, DevMenOverlayDisp_functions
					BLX		R7
								
refresh_disp_out	MOV		R0, R4
					LDR		R7, DevMenOverlayDisp_outbuf_prep
					BLX		R7

					LDR     R7, DevMenOverlayDisp_RefreshScreen
					BLX		R7

refresh_time		CMP		R6, #0 ; nopatch?
					BEQ		refresh_time_def	
					
					LDR		R1, [R6,#mp_sy_refresh_time] 
					CMP		R1, #8 ; prevent overload
					BGE		refresh_time_hi
					
					MOV		R1, #8
					B		refresh_do

refresh_time_hi		MOV		R0, #8
					LSL		R0, #8
					ADD		R0, #0x77 ; = 0x877 = 2167 = 10 sec
					CMP		R1, R0 ; prevent hang
					BLT		refresh_do		

					
refresh_time_def	MOV		R1, #0xA0 ; default cycle time nopatch	

refresh_do			LDR		R0, [SP, #sp_refresh_timer]
					LDR		R2, DevMenOverlayDisp
					BL		f077_CallAfterTimer
								
					
					ADD		SP,#sp_refresh_size ; string space
					POP		{R1-R3, R6}
					ADD     SP, #0x78 
				    POP     {R4,R5,R7,PC}

; ---------------------------------------------------------------------

_get_style			PUSH	{R4, R5, LR} ; input : R0=0 from screen. r0=1 from refresher
					MOV		R4, R0
					LDR		R5, patch_ptr					
					
					LDRB	R0, [R5, #ram_mode] ; current state: 0=on, 1=off, 2=special
					CMP		R0, #0
					BEQ		_get_style_test
					
					SUB		R0, #1
					BNE		_get_style_buf ; special
					
					MOV		R0,#0xFE
					B		_get_style_off
								
_get_style_test		BL		v18_ram_IsShutdown
					LDRB	R0, [R7]
					CMP		R0, #1
					BEQ		_get_style_mainscr
					
					BL		v19_ram_mainscreen_accu_icon
					MOV		R0, #0
					LDRSH	R7, [R7, R0]
					CMP		R7, #0
					BPL		_get_style_mainscr
					
					BL		f066_IsScreenSaver
					BEQ		_get_style_menues
									
_get_style_scrsav	MOV		R0, #3
					B		_get_style_buf
					
_get_style_mainscr	MOV		R0, #2
					B		_get_style_buf

_get_style_menues	MOV		R0, #4
		
_get_style_buf		SUB		R0, #1
					
					CMP		R4, #1 ; called by refresher
					BEQ		_get_style_buf_ok
					
					LDRB	R1, [R5, #ram_last_pstyle] ; FF if phone changed gui state
					CMP		R1, #0xFF
					BEQ		_get_style_lock	
					
					CMP		R0, R1
					BEQ		_get_style_buf_ok
					
_get_style_lock		MOV		R0, #0xFF

_get_style_off		MOV		R6, #0
					B		_get_style_x
					
_get_style_buf_ok	MOV		R1, #mp__record_size
					MUL		R1, R0
					ADD		R6, R1
					ADD		R6, #mp__first_record_off ; adjust masterpatch buffer to selected record start
					

_get_style_x		STRB	R0, [R5, #ram_last_pstyle] ; FF if phone changed gui state . FE
					POP		{R4, R5, PC} ; R6 sets bits: R6=0, R6=FF if wait for refresher string update (only in screen), else buffer
								

; =====================================================================

patch_ptr							DCD	0xA8000210

DevMenOverlayDisp					DCD	0xA08C8957

DevMenOverlayDisp_functions			DCD	0xA08C89B7
DevMenOverlayDisp_outbuf_prep		DCD	0xA1149673
DevMenOverlayDisp_RefreshScreen		DCD	0xA1149701

ScreenWindow_Metrics				DCD	0xA114A30C+1
ScreenWindow_Text					DCD	0xA116647C+1
ScreenWindow_Color					DCD	0xA1163C5A+1
; ScreenWindowPushBuffer_f			DCD	0xA11496B5
;ScreenWindowPushBuffer				DCD	0xA11496E0+1
;ScreenWindowReleaseBuffer			DCD	0xA1146414+1

Screen_OverlayDisplay_return		DCD	0xA114640B


ram_increasing_number				DCD 0xA8001748
ram_serial_armdebugger_packets		DCD 0xA8739EF4
Ram_Timer975_inc					DCD 0xA8717FFC         
ram_netmode_2						DCD	0xA8752560
ram_accupoint						DCD 0xA86B4144
ram_funnybyte						DCD	0xA8638E1C

mp_id								DCD	0xCCCB	
;col_fg								DCB	0,0,0xFF,0x55	
;col_bg								DCB	0,0,0x2C,0x48	

;format1								DCB "tk %d, cpu %03d net2: %02X , rx: %d - so, der text kommt noch langbla bla bla",0
;format1								DCB "tk %05d, cpu %03d net2: %02X , rx: %02d",0



 ALIGN
style_nopatch						DCB	0,6,2,0,0,0,132,20 ; unused,font,alignenemt,ovl,xy0,xy1
									DCB	0xFF,0xFF,0xFF,100, 0,0,0,100 ; colors
									; void else stuff for this func

								
mystring							dcb "smooth",0

;_mywstring							DCD	mywstring
;mywstring							DCB 05,00,"b",0,"e",0,"n",0,"j",0,"9",0
				END

; =============================================================

mytest				PUSH	{R1-R7,LR}
					SUB		SP, #0x180		

					
					MOV		R0, #50
					STR		R0,[SP]
					MOV		R3, #110
					MOV		R2, #35
					MOV		R1,#10
					
					ADD     R0, SP, #0x10					
					LDR		R7, ScreenWindow_Metrics ; ; R0=buf, R1=x, R2=y, R3=width,[SP]=height
					BLX		R7
					
					
					ADR		R1, col_fg
					ADD		R2, R1, #4
					ADD     R0, SP, #0x20					
					LDR		R7, ScreenWindow_Color ;
					BLX		R7
					
					
					ADD     R1, SP, #0x10
					ADD     R0, SP, #0x20
					MOV		R2,#0
					MOV		R3,#0
					STR		R3,[SP,#4]
					MOV		R2,#0
					STR		R3,[SP]
					ADR		R3,_mywstring		
					MOV		R2,#0
									
					LDR		R7, ScreenWindow_Text ; R0=buffer, R1=points2 general_metrics,; R2=inversion?, r3=ptr2ws,; SP=font, sp+4=alignement?
					BLX		R7
					
					
					ADD		R0, SP, #0x20
					; ADD     R1, SP, #0x10
					LDR		R7, ScreenWindowPushBuffer
					BLX		R7		
					
					LDR		R0,=0xA8750000
					MOV		R1,#2
					LSL		R1,#8
					LDR		R2,_mytest
					BL		f077_CallAfterTimer
					
					ADD		SP, #0x180	
					POP		{R1-R7,PC}
					
_mytest				DCD		mytest	
__mywstring			DCD	_mywstring				
_mywstring			DCD	mywstring				
mywstring			DCB 05,00,"b",0,"e",0,"n",0,"j",0,"9",0



; ----


